#include "ShaderConstants.fxh"
#include "Util.fxh"

struct PS_Input {
	float4 position : SV_Position;
#ifdef ENABLE_LIGHT
	float4 light : LIGHT;
#endif
#ifdef ENABLE_FOG
	float4 fogColor : FOG_COLOR;
#endif

#ifndef DISABLE_TINTING
	float4 color : COLOR;
#endif

	float4 texCoords : TEXCOORD_0_FB_MSAA;
};

struct PS_Output
{
	float4 color : SV_Target;
};

#include "dect.fxh"

ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.texCoords.xy);
	float4 base = TEXTURE_0.Sample(TextureSampler0, PSInput.texCoords.zw);

#ifndef DISABLE_TINTING
	base.a = lerp(diffuse.r * diffuse.a, diffuse.a, PSInput.color.a);
	base.rgb *= PSInput.color.rgb;

#endif

float4 lig = float4(0.0,0.0,0.0,0.0);

#ifdef ENABLE_LIGHT
	base.rgb *= PSInput.light.rgb;
	lig = PSInput.light;
#endif

    float4 tep = FOG_COLOR;
    float chuva = Rain(FOG_CONTROL);
    float dia = lerp(pow(max(min(tep.r * 1.5+0.3, 1.0), 0.0), 1.2),1.0,chuva);
	
	float3 Lal = float3(0.5,0.2,-0.3);
    float3 Lb = float3(0.5,0.2,-0.3) * 0.5;
    float pisc = 0.2 * cos(TIME * 0.3 * cos(0.3 * TIME));
    float3 Ll = lerp(Lal, Lb, lerp(pisc,0.0,lerp(0.0,1.,pow(TILE_LIGHT_COLOR.x,1.6))));
    
	float3 La = float3(0.5,0.1,-0.3);
	float3 Nc = max(base.rgb,float3(0.0,0.0,1.5));
	float3 Cn = lerp( Nc*Nc, Ll* 1.8,pow(TILE_LIGHT_COLOR.x,1.5));
	float3 Cc = lerp( lig.rgb, float3(1.35,1.34,1.31)*1.2, pow( lig.g,0.5));
	float3 chd = lerp(float3(1.0,1.0,1.0),  lerp(float3(0.5,0.5,0.5) *  lig.rgb, Ll* 1.8, pow(TILE_LIGHT_COLOR.x,10.0)), chuva);

if(TILE_LIGHT_COLOR.b <= 0.99){
if(End(FOG_COLOR)){
    base.rgb *= float3(0.511,0.362,0.985);
    base.rgb += lerp(float3(0.0,0.0,0.0), base.rgb * float3(0.511,0.362,0.985) * 1.2 , pow(TILE_LIGHT_COLOR.x, 2.0));
}else{
if(Nether(FOG_CONTROL)){//nether
	//nether do fumaça
	base.rgb += lerp(float3(0.0,0.0,0.0),  lerp(La * 2.5, La * 6.0, pow(TILE_LIGHT_COLOR.x,0.8)), clamp(FOG_COLOR.x - 0.1, 0.0, 1.0));
	//nether gases de azul
	base.rgb *= lerp(base.rgb, float3(-0.2,-0.2,4.0), clamp(FOG_COLOR.y - (FOG_COLOR.x - 0.1), 0.0, 1.0));
	base.rgb += lerp(float3(0.0,0.0,0.0) ,(float3(0.0,0.0,base.b) * 15.0) * pow(TILE_LIGHT_COLOR.x,5.0), clamp(FOG_COLOR.y - (FOG_COLOR.x - 0.1), 0.0, 1.0));
	base.rgb += lerp(base.rgb, lerp(-float3(0.0,0.1,0.1) * 1.5, La * 2.0, pow(TILE_LIGHT_COLOR.x,3.0)), clamp(FOG_CONTROL.x - FOG_COLOR.y, 0.0, 1.0));
}else{
if(Underwater(FOG_CONTROL)){
	base.r *= 0.3;
	base.rgb *= lerp(lerp(float3(0.2,0.2,0.3), float3(0.0,0.5,1.0), pow(lig.g,1.0)), base.rgb, pow(TILE_LIGHT_COLOR.x,2.0));
}else{

if(FOG_COLOR.g > 0.0 && FOG_COLOR.g < 0.1){
base.rgb *= lerp(Cn, chd, chuva);
}else{
base.rgb *= lerp(lerp(float3(1.0,1.0,1.0), Cc * lig.g, dia), chd, chuva);
if(TILE_LIGHT_COLOR.r < 0.91) {
base.rgb *= lerp(float3(0.7,0.7,0.7), float3(1.0,1.0,1.0), chuva);
}
}}}}}


#ifdef ENABLE_FOG
	//apply fog
	base.rgb = lerp(base.rgb, PSInput.fogColor.rgb, PSInput.fogColor.a );
#endif

	//WARNING do not refactor this 
	PSOutput.color = base;
#ifdef UI_ENTITY
	PSOutput.color.a *= HUD_OPACITY;
#endif

#ifdef VR_FEATURE
	// On Rift, the transition from 0 brightness to the lowest 8 bit value is abrupt, so clamp to 
	// the lowest 8 bit value.
	PSOutput.color = max(PSOutput.color, 1 / 255.0f);
#endif
}